/*
 * nn_esc_1d.h
 *
 *  Created on: Jul 26, 2012
 *      Author: Berk Calli
 *      Organization: Delft Biorobotics Lab., Delft University of Technology
 *		Contact info: b.calli@tudelft.nl, web: www.dbl.tudelft.nl
 *
 * Header file of the class for one dimensional neural network based extremum seeking control
 *
 * * References:
 * - M. Teixeira and S. Zak, “Analog neural nonderivative optimizers,” IEEE Transactions on Neural Networks, vol. 9, pp. 629–638, 1998.
 * - B. Calli, W. Caarls, P. Jonker and M. Wisse, "Comparison of Extremum Seeking Control Algorithms for Robotic Applications", IROS 2012.
 */
#

#ifndef NN_ESC_1D_H_
#define NN_ESC_1D_H_

#include <vector>
#include <string>
#include "esc_common/esc.h"
#include "stdio.h"
class NNESC1D : public ESC {
public:
	enum { monitorSwitch, monitorPeak };

protected:
	double A_,M_,ddelta_,A,delta_,B_, mpd_init_, w_switch_old_, a_switch_old_,yr_,period_;
	double min_peak_,vel_ref_,w_switch_;
	bool initialized_,min_peak_detect_init_;

public:
	NNESC1D();

	NNESC1D(double A,double M, double B, double ddelta, double delta, double period);

	void init(double A, double M, double B, double ddelta, double delta, double period);

	std::vector<double> step(double obj_val);
	inputType getInputType();
	outputType getOutputType();
	std::vector<double> monitor();
	std::vector<std::string> monitorNames();
protected:
	double wSwitch(double e_minus);
	double minPeakDetect(double e_minus);
	double aSwitch(double e);

};


#endif /* NN_ESC_1D_H_ */
