var log        = null;
var container  = null;
var connection = null;
var map        = null;

/// Create a circle model.
function circleModel(radius) {
	var svg    = document.createElementNS(webmap.svgns, "g");
	var circle = document.createElementNS(webmap.svgns, "circle");
	var line   = document.createElementNS(webmap.svgns, "line");
	svg.appendChild(circle);
	svg.appendChild(line);
	
	circle.setAttribute("cx", 0);
	circle.setAttribute("cy", 0);
	circle.setAttribute("r", radius);
	
	line.setAttribute("x1", 0);
	line.setAttribute("y1", 0);
	line.setAttribute("x2", radius);
	line.setAttribute("y2", 0);
	
	return svg;
}

/// Example robot class for Stage robots.
function StageRobot(name, index, connecion) {
	
	// Create SVG content.
	var svg = circleModel(0.2);
	
	// Call parent constructor.
	webmap.Robot.call(this, name, svg);
	
	// Add CSS classes.
	this.svg.classList.add("stage");
	this.svg.classList.add("stage_" + index);
	
	// Set up odometry, navigation and laser scanner.
	var topic_base = "/robot_" + index;
	this.setOdometryTopic(connection, topic_base + "/odom");
	this.setTwistTopic(connection, topic_base + "/cmd_vel");
	this.addModule("LaserScanner", connection, topic_base + "/base_scan");
}

webmap.extend(webmap.Robot, StageRobot);

function init() {
	log        = document.getElementById("log");
	container  = document.getElementById("webmap_container");
	
	// Create the map.
	map = new webmap.Map(container, 700, 500);
	map.addModule("MouseViewControl", 1, 1.5);
	map.addModule("ShowSelected", document.getElementById("selected"));
	map.addModule("Teleop", 1, 1.5);
	map.addImage("background.png", -29.35, -27, 58.7, 54.0);
	map.scale(500 / 58.7, map.canvas_width * 0.5, map.canvas_height * 0.5);
	
	// Create the rosbridge connection.
	connection = new ros.Bridge("ws://localhost:9090");
	connection.onClose = function (e) {
		log.textContent = "Connection closed.\n" + log.textContent;
	};
	connection.onError = function (e) {
		log.textContent = "Error: " + e + ".\n" + log.textContent;
	};
	connection.onOpen = function (e) {
		log.textContent = "Connection established.\n" + log.textContent;
		// Add two Stage robots.
		map.addRobot(new StageRobot("Robot 0", 0, connection));
		map.addRobot(new StageRobot("Robot 1", 1, connection));
	};
}

document.addEventListener("DOMContentLoaded", init, false);
