/*
 * esc.h
 *
 *  Created on: Jul 26, 2012
 *      Author: Berk Calli, Wouter Caarls
 *      Organization: Delft Biorobotics Lab., Delft University of Technology
 *		Contact info: b.calli@tudelft.nl, web: www.dbl.tudelft.nl
 *
 * Superclass for extremum seeking control algorithms
 */

#ifndef ESC_H_
#define ESC_H_
#include <vector>
#include <string>
#define PI 3.141592654

/// Superclass for extremum seeking control algorithms.
class ESC
{
  public:
    /// Controller input type
    enum inputType
    {
      inputStateValue, ///< State-value input.
      inputValue       ///< Value input.
    };
	
    /// Controller output type.
    enum outputType
    {
      outputVelocity,  ///< Velocity reference output.
      outputPosition   ///< Position reference output.
    };

public:
    virtual ~ESC() { }

    /// Get internal monitor variable names.
    virtual std::vector<std::string> monitorNames() { return std::vector<std::string>(); }
	
    /// Get internal monitor variables.
    virtual std::vector<double> monitor() { return std::vector<double>(); }

    /// Get controller input type.
    virtual inputType getInputType() = 0;
	
    /// Get controller output type.
    virtual outputType getOutputType() = 0;

    /// Control step function for value-input control algorithms.
    virtual std::vector<double> step(std::vector<double> state, double obj_val)
    {
      return step(obj_val);
    }

    /// Control step function for state-input control algorithms.
    virtual std::vector<double> step(double obj_val)
    {
      return std::vector<double>();
    }

    /// Reset control algorithm to initial conditions.
    virtual void reset() = 0;
};

#endif /* ESC_H_ */
