#ifndef __SS_CLIENT_H_
#define __SS_CLIENT_H_

#include <ros/ros.h>

class SerialClient
{
  protected:
    ros::NodeHandle nh_;
    ros::ServiceClient connect_service_;
    ros::ServiceClient sendto_service_;
    ros::ServiceClient recv_service_;
    ros::ServiceClient sendrecv_service_;
    ros::Publisher     send_topic_;
    ros::Publisher     close_topic_;
    ros::Publisher     flush_topic_;

  public:
    void init(const char *path="/comm");

    int connect(float timeout);
    int sendto(int socket, const unsigned char *data, size_t length, float timeout);
    int recv(int socket, int length, float recv_timeout, float sock_timeout, unsigned char *data, size_t *data_length);
    int sendrecv(int socket, const unsigned char *send_data, size_t send_length, size_t recv_length, float recv_timeout, float sock_timeout, unsigned char *recv_data, size_t *recv_data_length);
    void send(int socket, const unsigned char *data, size_t length, float timeout);
    void close(int socket);
    void flush(int socket, float timeout);
};

#endif /* __SS_CLIENT_H_ */
