/*
 * node.cpp
 *
 *  Created on: July 24, 2012
 *      Author: Berk Calli
 *      Organization: Delft Biorobotics Lab., Delft University of Technology
 *		Contact info: b.calli@tudelft.nl, web: www.dbl.tudelft.nl
 *
 *	Node for neural network extremum seeking control
 */

#include <esc_nn/nn_esc_1d.h>
#include "esc_ros/esc_ros.h"

int main(int argc, char **argv) {

	ros::init(argc, argv, "nn_esc_1d");
	ros::NodeHandle n("~");

	double A, B, M, ddelta, delta, period;
	if (!n.getParam("A", A)){
		ROS_WARN("[nn_esc_1D]: Failed to get the parameter A from the parameter server. Using the default value.");
		A = 0;
	}
	if (!n.getParam("B", B)){
		ROS_WARN("[nn_esc_1D]: Failed to get the parameter B from the parameter server. Using the default value.");
		B = 0;
	}
	if (!n.getParam("M", M)){
		ROS_WARN("[nn_esc_1D]: Failed to get the parameter M from the parameter server. Using the default value.");
		M = 0;
	}
	if (!n.getParam("ddelta", ddelta)){
		ROS_WARN("[nn_esc_1D]: Failed to get the parameter ddelta from the parameter server. Using the default value.");
		ddelta = 0;
	}
	if (!n.getParam("delta", delta)){
		ROS_WARN("[nn_esc_1D]: Failed to get the parameter delta from the parameter server. Using the default value.");
		delta = 0;
	}
	if (!n.getParam("period", period)){
		ROS_WARN("[nn_esc_1D]: Failed to get the parameter period from the parameter server. Using the default value.");
		period = 0;
	}

	ESCROS esc_ros(&n);
	NNESC1D* nn_esc_1d = new NNESC1D(A,M,B,ddelta,delta,period);
	esc_ros.init(nn_esc_1d);
	esc_ros.spin();

	return 0;
}
