/*
 * esc.h
 *
 *  Created on: Jul 26, 2012
 *      Author: Berk Calli, Wouter Caarls
 *      Organization: Delft Biorobotics Lab., Delft University of Technology
 *		Contact info: b.calli@tudelft.nl, web: www.dbl.tudelft.nl
 *
 * Superclass for extremum seeking control algorithms
 */

#ifndef ESC_H_
#define ESC_H_
#include <vector>
#include <string>
#define PI 3.141592654
class ESC
{
public:

	enum inputType { inputStateValue, inputValue };
	enum outputType { outputVelocity, outputPosition };

public:
	virtual ~ESC() { }

	virtual std::vector<std::string> monitorNames() { return std::vector<std::string>(); }
	virtual std::vector<double> monitor() { return std::vector<double>(); }

	virtual inputType getInputType() = 0;
	virtual outputType getOutputType() = 0;

	virtual std::vector<double> step(std::vector<double> state, double obj_val)
	{
		return step(obj_val);
	}

	virtual std::vector<double> step(double obj_val)
	{
		return std::vector<double>();
	}
};


#endif /* ESC_H_ */
