#include <stdio.h>
#include <phidget_ik/phidget_ik.h>

int main(void)
{
  PhidgetIK phidget_ik;
  
  phidget_ik.init(-1);
  phidget_ik.waitForAttachment(1000);
  
  int inputs = phidget_ik.getInputCount();
  if (phidget_ik.getLastError())
  {
    std::cerr << "Error initializing PhidgetInterfaceKit: " << phidget_ik.getErrorDescription(phidget_ik.getLastError()) << std::endl;
    return 1;
  }
  
  for (int ii=0; ii != inputs; ii++)
    std::cout << "Input " << ii << " has state " << phidget_ik.getInputState(ii) << std::endl;

  return 0;
}
