/*
 * approx_esc_2d.h
 *
 *  Created on: Jul 31, 2012
 *      Berk Calli
 *      Organization: Delft Biorobotics Lab., Delft University of Technology
 *		Contact info: b.calli@tudelft.nl, web: www.dbl.tudelft.nl
 *
 * Header file of the class for one dimensional approximation based extremum seeking control
 *
 * * References:
 * - C. Zhang and R. Ordonez, “Robust and adaptive design of numerical optimization-based extremum seeking control,” Automatica, vol. 45, pp. 634–646, 2009.
 * - B. Calli, W. Caarls, P. Jonker and M. Wisse, "Comparison of Extremum Seeking Control Algorithms for Robotic Applications," IROS 2012.
 */


#ifndef APPROX_ESC_2D_H_
#define APPROX_ESC_2D_H_

#include "esc_common/esc.h"
#include <vector>
#include <eigen3/Eigen/Dense>
#include "stdio.h"
class ApproxESC2D:public ESC{
protected:
	int data_size_,sampling_;
	double k_grad_, init_vel_;
	bool initialized_;
	int sample_, ptr_;
	Eigen::MatrixXf states_;
	Eigen::VectorXf obj_vals_;
	Eigen::VectorXf vel_ref_,state_curr_;
public:
	ApproxESC2D();
	ApproxESC2D(int data_size, double k_grad, double init_vel, int sampling = 1);
	void init(int data_size, double k_grad, double init_vel, int sampling = 1);
	std::vector<double>  step(std::vector<double> state, double obj_val);
	inputType getInputType();
	outputType getOutputType();
	std::vector<double> monitor();
	std::vector<std::string> monitorNames();
	void reset();

};


#endif /* APPROX_ESC_2D_H_ */
