/*
 * perturb_esc_nd.h
 *
 *  Created on: Aug 1, 2012
 *      Author: Berk Calli
 *      Organization: Delft Biorobotics Lab., Delft University of Technology
 *		Contact info: b.calli@tudelft.nl, web: www.dbl.tudelft.nl
 *
 * Header file of the class for perturbation based extremum seeking control
 *
 * * References:
 * - K. B. Ariyur and M. Krstic, "Real-Time Optimization by Extremum-Seeking Control", Wiley, 2003.
 * - B. Calli, W. Caarls, P. Jonker, M. Wisse, "Comparison of Extremum Seeking Control Algorithms for Robotic Applications", IROS 2012.
 */

#ifndef PERTURB_ESC_ND_H_
#define PERTURB_ESC_ND_H_

#include <vector>
#include <cmath>
#include <stdio.h>
#include "esc_common/esc.h"
class PerturbESCND:public ESC{
protected:
	double sin_amp_,sin_freq_,corr_gain_,high_pass_pole_,low_pass_pole_,comp_pole_,comp_zero_,period_,obj_val_old_, hpf_out_old_, cycle_count_;
	std::vector<double> pos_ref_, signal_demodulated_old_, lpf_out_old_,corr_signal_, phase_shift_,comp_old_;
	unsigned int opt_dim_;
	bool initialized_,state_initialized_, old_vals_initialized_;

public:
	PerturbESCND();
	PerturbESCND(double sin_amp, double sin_freq, double corr_gain, double high_pass_pole, double low_pass_pole, double comp_zero, double comp_pole, double period);
	void init(double sin_amp, double sin_freq, double corr_gain, double high_pass_pole, double low_pass_pole, double comp_zero, double comp_pole, double period);
	std::vector<double>  step(std::vector<double> state, double obj_val);
	inputType getInputType();
	outputType getOutputType();
	std::vector<double> monitor();
	std::vector<std::string> monitorNames();
};

#endif /* PERTURB_ESC_ND_H_ */
