/*
 * nn_esc_2d.h
 *
 *  Created on: Jul 31, 2012
 *      Author: Berk Calli
 *      Organization: Delft Biorobotics Lab., Delft University of Technology
 *		Contact info: b.calli@tudelft.nl, web: www.dbl.tudelft.nl
 *
 * Header of the class for two dimensional neural network extremum seeking control
 *
 * * References:
 * - M. Teixeira and S. Zak, “Analog neural nonderivative optimizers,” IEEE Transactions on Neural Networks, vol. 9, pp. 629–638, 1998.
 * - B. Calli, W. Caarls, P. Jonker and M. Wisse, "Comparison of Extremum Seeking Control Algorithms for Robotic Applications", IROS 2012.
 */

#ifndef NN_ESC_2D_H_
#define NN_ESC_2D_H_

#include <vector>
#include <string>
#include "esc_common/esc.h"
#include "stdio.h"

class NNESC2D : public ESC {

protected:
	double A_,M_,ddelta1_,ddelta2_,ddelta3_,delta_,B_, mpd_init_, w_switch_old_, a_switch1_old_, a_switch2_old_, a_switch3_old_,yr_,period_;
	double min_peak_,w_switch_;
	std::vector<double> vel_ref_;
	bool initialized_,min_peak_detect_init_;

public:
	NNESC2D();

	NNESC2D(double A,double M, double B, double ddelta1, double ddelta2, double ddelta3, double delta, double period);

	void init(double A, double M, double B, double ddelta1, double ddelta2, double ddelta3, double delta, double period);

	std::vector<double> step(double obj_val);
	inputType getInputType();
	outputType getOutputType();
	std::vector<double> monitor();
	std::vector<std::string> monitorNames();
	void reset();
protected:
	double wSwitch(double e);
	double minPeakDetect(double e);
	double aSwitch1(double e);
	double aSwitch2(double e);
	double aSwitch3(double e);

};

#endif /* NN_ESC_2D_H_ */
