/*
 * sm_esc_1d.h
 *
 *  Created on: Jul 30, 2012
 *      Author: Berk Calli
 *      Organization: Delft Biorobotics Lab., Delft University of Technology
 *		Contact info: b.calli@tudelft.nl, web: www.dbl.tudelft.nl
 *
 * Header file of the class for one dimensional sliding mode extremum seeking control with periodic driving signal
 *
 * * References:
 * - H. Yu and U. Ozguner, “Extremum-seeking Control Strategy for ABS System with Time Delay,” ACC 2002.
 * - B. Calli, W. Caarls, P. Jonker and M. Wisse, "Comparison of Extremum Seeking Control Algorithms for Robotic Applications", IROS 2012.
 */


#ifndef SM_ESC_1D_H_
#define SM_ESC_1D_H_

#include "esc_common/esc.h"
#include "stdio.h"
#include "cmath"
using std::sin;

class SMESC1D : public ESC {
protected:
	double rho_,k_,alpha_,driving_input_,vel_ref_;
	bool initialized_,driving_input_init_;
public:
	SMESC1D();
	SMESC1D(double rho, double k, double alpha);
	void init(double rho, double k, double alpha);
	inputType getInputType();
	outputType getOutputType();
	std::vector<double> step(double obj_val);
	std::vector<double> monitor();
	std::vector<std::string> monitorNames();
	void reset();
protected:
	int sign(double value);
};


#endif /* SM_ESC_1D_H_ */
